/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.util;

import com.aizistral.enigmaticlegacy.api.capabilities.IPlaytimeCounter;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurseUtil {
    public static long curseTime(Player player) {
        IPlaytimeCounter counter = IPlaytimeCounter.get((Player)player);
        return counter.getTimeWithCurses();
    }

    public static CompoundTag getCurseCurioData(Player player) {
        LazyOptional handler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        ItemStack curseCurio = null;
        if (handler.resolve().isPresent()) {
            block0: for (ICurioStacksHandler curios : ((ICuriosItemHandler)handler.resolve().get()).getCurios().values()) {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStacks().getStackInSlot(i);
                    if (!stack.m_150930_((Item)EnigmaticItems.CURSED_RING)) continue;
                    curseCurio = stack;
                    continue block0;
                }
            }
        }
        if (curseCurio != null) {
            return curseCurio.m_41784_();
        }
        return null;
    }

    public static int getPunishTime(Player player) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return 0;
        }
        return data.m_128451_("punish_time");
    }

    public static void setPunishTime(Player player, int day) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return;
        }
        data.m_128405_("punish_time", day * 300);
    }

    public static int getDeathFrequency(Player player) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return 0;
        }
        return data.m_128451_("death_frequency");
    }

    public static void setDeathFrequency(Player player, int fre) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return;
        }
        data.m_128405_("death_frequency", fre);
    }

    public static int getResoluteTime(@NotNull Player player) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return 0;
        }
        return data.m_128451_("resolute");
    }

    public static void setResoluteTime(Player player, int resoluteTime) {
        CompoundTag data = CurseUtil.getCurseCurioData(player);
        if (data == null) {
            return;
        }
        data.m_128405_("resolute", resoluteTime);
    }
}

